# Kernel→Metric (FPHS) Simulation

This repository implements a prototype of the *Kernel → Metric* bridge in the
Absolute Relativity (AR) project.  It takes a calibrated FPHS pivot–kernel
field and maps it into an effective geometric medium.  The aim is to test
whether the same pivot parameters that reproduce quantum gauge observables
also generate classical inverse–power laws and lensing behaviour without
introducing new free structures.

## Contents

```
kernel-to-metric-fphs/
├── README.md            – project description (this file)
├── LICENSE              – MIT licence
├── CITATION.cff         – citation metadata
├── MANIFEST.json        – hashes of all inputs and config
├── env/
│   ├── requirements.txt – pip dependencies
│   └── environment.yml  – optional conda environment
├── configs/anchors.yaml – simulation anchors (L, b, kappa, lambda, ell)
├── data/
│   ├── D_values.csv      – (n,D) fractal dimension anchors from Vol 3
│   ├── pivot_params.json – pivot fit parameters (a,b) from Vol 4
│   └── (generated at run time) – envelope grids are stored in the `.npz` files under `runs/`
├── src/k2m/             – Python modules implementing the simulation
├── scripts/             – command‑line entry points
├── runs/                – JSON and NPZ outputs (generated)
├── results/plots/       – plots summarising the run (generated)
└── reports/REPORT.md    – run summary (generated)
```

## Data provenance

The inputs in the `data/` directory come from FPHS research repositories
accessible through the internal GitHub connector.  `D_values.csv` lists
fractal dimensions for several context levels n.  `pivot_params.json` contains
the linear pivot fit parameters `a` and `b` with which we compute the pivot
function g(D) = a × D + b.  SHA‑256 hashes for these files and the exact
commit IDs are recorded in `MANIFEST.json`.

## Building the envelope

1. **Pivot weights.**  For each pair `(n, D)` in `D_values.csv` we
   evaluate the pivot function `g(D) = a × D + b` using the fit
   parameters in `pivot_params.json`.  This produces a single pivot
   weight for each context level.
2. **Radial interpolation.**  The context levels `n` are sorted and
   rescaled to the interval `[0, 1]`.  We treat these rescaled
   values as radial shells and linearly interpolate the pivot weights
   across the lattice radius.  The centre of the lattice uses the
   weight corresponding to the smallest `n`, while the boundary uses
   the largest.
3. **2D field.**  For a lattice of size `L` the distance of each site
   from the centre is computed and mapped through the radial
   interpolation from step 2.  To reflect the finite correlation length
   of the underlying Hamiltonian‑derived kernels we optionally apply a
   radial decay factor of the form exp(−α r²).  The decay parameter α
   is specified in the configuration (`decay_alpha` in
   `configs/anchors.yaml`) and can be set to zero to disable decay.  A
   modest value (e.g. 4.0) localises the source so that the far field
   follows a 1/r law.  The resulting scalar field `E0(x,y)` is then
   multiplied by a gauge factor to distinguish SU(3) from SU(2): by
   default SU(3) uses a factor of 1.0 and SU(2) uses 0.8.  These
   grids are saved under `runs/*.npz` at run time.
4. **Smoothing and normalisation.**  A Gaussian of width ell lattice units
   smooths the envelope.  The gradient magnitude is then computed and
   divided by its spatial mean to obtain a dimensionless profile
   used by both translators.

## Translators

* **Poisson translator.**  Defines a source density S = λ × Ĝ.  Convolves
  this source with the 3D Green’s function of a thin sheet,
  Gε(r) = 1 / √(r² + ε²) (with ε = 0.5 ell), using zero padding to avoid
  wrap‑around.  The potential V and field E = −∇V are then analysed.

* **Optical translator.**  Defines an index of refraction
  n = 1 + λ × Ĝ.  Parallel rays with impact parameters b in [4 ell,
  0.3 L] propagate through this medium; their angular deflections are
  recorded.  A first‑order paraxial approximation is used for numerical
  stability.

## Running the code

Install Python dependencies and run the full suite of simulations via:

```
pip install -r env/requirements.txt
bash scripts/run_all.sh
```

This will produce a set of JSON files in `runs/`, NPZ arrays of intermediate
results, summary plots under `results/plots/`, and a Markdown report in
`reports/REPORT.md`.  Use `python scripts/aggregate.py` to collect the outputs
into a single CSV or Parquet table.

## Licence and citation

The code in this repository is released under the MIT Licence (see
`LICENSE`).  If you use this work in academic publications, please cite
the accompanying citation file `CITATION.cff`.
